﻿var testPhoneTemplate = {
    context: $(".v-testPhoneTemplate"),
    initialize: function () {
        this.bindEvents();
        a4.initializeInputs(this.context);
    },
    bindEvents: function () {
        $("#testTemplate", this.context).on("click", function () {
            a4.callServerMethod(a4.getAction("testPhoneTemplate", "MultiMode", "Settings"), { id: $("#Id", testPhoneTemplate.context).val(), phoneNumber: $("#PhoneNumber", testPhoneTemplate.context).val() },
                function (result) {
                    testPhoneTemplate.bindResult(result.result);
                },
                null,
                { blockElement: testPhoneTemplate.context });
        });
    },
    bindResult: function (result) {
        $(".v-selectedExpression", testPhoneTemplate.context).html(result.SelectedExpression);
        $(".v-selectedCondition", testPhoneTemplate.context).html(result.SelectedCondition);
        $(".v-selectedAction", testPhoneTemplate.context).html(result.SelectedAction);
        $(".v-dialNumber", testPhoneTemplate.context).html(result.DialNumber);
        $(".v-checksum", testPhoneTemplate.context).html(result.Checksum);
    }
};

$(document).ready(function () {
    if (testPhoneTemplate.context.length > 0) {
        testPhoneTemplate.initialize();
    }
});